; ****************************
; *     Vintage Computing    *
; * Christmas Challenge 2021 *
; ****************************

;Leosoft's entry

;duration = 5156 NOPs


di            ;because we use shadow regs

;Initialize values of shadow registers
;=====================================
;(for the drawing routine)
exx
  push bc       ;backup bc' first!
  ;setup the four pixel maps for the star character
  ld bc,&6030
  ld de,&c0f0
  ;setup starting screen adress
  ld hl,&caa7   ;(starts in scanline #1, exact center screen
                ;with this adress, we can use inc L instead of inc HL
exx


;Values in the main loop
;=======================
;B = counter for 4 lines per section
;C = length (in stars) of current line
;D = counter for tree sections (init 3)
;E = growth per line in current section (in stars, init 2)
;H = screen width (constant 80 = &50)
;L = offset to add to HL' for next screen line start (init 1)
ld de,&0302
ld hl,&5001


;Main loop (tree section)
;========================

  tree_section:
  ld c,e     ;calculate length of first line
  dec c      ;every row starts with (growth-1) stars
  ld b,4     ;set counter to four lines per section

    section_line:
    ld a,l      ;restore offset
    sub c       ;subtract new line length from offset
                ;(-> half line left from center)
    exx
      add l     ;add new offset to HL'
      ld l,a
      jr nc,$+3
        inc h
    exx

    ld a,c      ;get line length, A is counter for following loop

    exx
      draw_star:
      ld (hl),b   ;draw line #1
      inc l
      ld (hl),b
      set 5,h     ;go to line #5
      ld (hl),b   ;draw line #5
      dec l
      ld (hl),b
      res 3,h     ;go to line #4
      ld (hl),c   ;draw line #4
      inc l
      ld (hl),d	  ;draw line #4
      res 5,h     ;go to line #2
      set 4,h
      ld (hl),d   ;draw line #2
      dec l
      ld (hl),c
      set 3,h     ;go to line #3
      ld (hl),e   ;draw line #3
      inc l
      ld (hl),e

      res 4,h     ;go back to line #1
      inc l       ;and to next position

      dec a
      jr nz,draw_star
    exx

    ;calc offset to center of next line
    ld a,h     ;(H=80)
    sub c      ;since one character is 2 bytes wide
               ;C is actually half a line
    ld l,a     ;save offset

    ;calculate length next of line
    ld a,c     ;load old length
    add e      ;add growth
    ld c,a     ;save new length

    djnz section_line

  inc e        ;increment growth for next section
  inc e

  dec d		   ;decrement section counter
  jr nz,tree_section

bit 1,e        ;if we get here for the 1st time, E=8
               ;then we go on to the trunk
jr nz,finish   ;after the trunk, E=2 and we finish

;else draw the trunk of the tree
ld bc,&0203    ;trunk is 2 lines high and 3 stars wide
ld e,d         ;E=0, no line growth (D was 0 before)
inc d          ;trunk is 1 section
jr section_line


finish:
exx
pop bc         ;restore BC' to keep basic happy
exx
ret
